﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using r15.Models;
using System.Web.Helpers;

namespace r15.Controllers
{
    public class HomeController : Controller
    {

        public ActionResult Index()
        {

            return View();
        }

        public ActionResult InlineHelper()
        {
            string[] days = {"Poniedziałek", "Wtorek", "Środa", "itd."};
            string[] fruits = { "Jabłka", "Mango", "Banany" };
            ViewBag.Days = days;
            ViewBag.Fruits = fruits;
            return View();
        }

        public ActionResult Grid()
        {

            IEnumerable<Product> productList = new List<Product> { 
        new Product {Name = "Kajak", Category = "Sporty wodne", Price = 275m}, 
        new Product {Name = "Kamizelka ratunkowa", Category = "Sporty wodne", Price = 48.95m}, 
        new Product {Name = "Piłka", Category = "Piłka nożna", Price = 19.50m}, 
        new Product {Name = "Flagi narożne", Category = "Piłka nożna", Price = 34.95m}, 
        new Product {Name = "Stadion", Category = "Piłka nożna", Price = 79500m}, 
        new Product {Name = "Czapka", Category = "Szachy", Price = 16m} 
    };

            return View(productList);
        }

        public void ChartImage()
        {

            IEnumerable<Product> productList = new List<Product> { 
        new Product {Name = "Kajak", Category = "Sporty wodne", Price = 275m}, 
        new Product {Name = "Kamizelka ratunkowa", Category = "Sporty wodne", Price = 48.95m}, 
        new Product {Name = "Piłka", Category = "Piłka nożna", Price = 19.50m}, 
        new Product {Name = "Flagi narożne", Category = "Piłka nożna", Price = 34.95m}, 
        new Product {Name = "Stadion", Category = "Piłka nożna", Price = 150m}, 
        new Product {Name = "Czapka", Category = "Szachy", Price = 16m} 
    };

            Chart chart = new Chart(400, 200,
                @"<Chart BackColor=""Gray"" BackSecondaryColor=""WhiteSmoke""   
                BackGradientStyle=""DiagonalRight"" AntiAliasing=""All""  
                BorderlineDashStyle = ""Solid"" BorderlineColor = ""Gray""> 
<BorderSkin SkinStyle = ""Emboss"" /> 
<ChartAreas> 
<ChartArea Name=""Default"" _Template_=""All"" BackColor=""Wheat""  
                        BackSecondaryColor=""White"" BorderColor=""64, 64, 64, 64""  
                        BorderDashStyle=""Solid"" ShadowColor=""Transparent""> 
</ChartArea> 
</ChartAreas> 
</Chart>");

            chart.AddSeries(
                chartType: "Column",
                yValues: productList.Select(e => e.Price).ToArray(),
                xValue: productList.Select(e => e.Name).ToArray()
                );

            chart.Write();
        }

        public ActionResult PartialDemo()
        {
            return View();
        }

        public ActionResult ChildActionDemo()
        {
            return View();
        }

        public ActionResult Time()
        {

            return View(DateTime.Now);
        }
    }
}
